/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: Hal_EddProfinetIRT.h $
   Last Modification:
    $Author: AndreassMe $
    $Modtime: 15.12.08 14:18 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : no
    rcX          : yes


  Description:

    Hardware abstraction layer for Profinet IRT XC code for edd driver.

   Changes:

     Date        Author        Description
     ----------------------------------------------------------------------------------
     2009-12-03		A. Messer		  implemented  external trigger signal (mantis #7847).
     
     2009-09-25   A. Messer     fixed problem with 2PortSwitch
     
     2009-09-24		A. Messer			Fixed linking issue.

     2009-09-23	  A. Messer		  Addapted IOCTL's to new xpec hal code. Made PLL more robust.

     2009-06-24   A. Messer     Added portstate ioctl.

     2009-05-04		A. Messer			Added identify ioctl.

     2009-03-02		A. Messer			Removed unused IOCTL's

     2009-02-16		A. Messer			Added IOCTLS for setting port mac address and
     														retrieving forward time.

     2009-02-02		A. Messer			Added Send offset support.

     2009-01-15		A. Messer			Modified struct for sync irq handling

     2009-01-05	 A. Messer		 added structs & ioctl needed for sync

     2008-12-15  A. Messer     initial version.
**************************************************************************************/

#ifndef HAL_EDDPROFINETIRT_H_
#define HAL_EDDPROFINETIRT_H_

/* check if this file is included by stack or by configuration file. depending
 * on this definitions will be enabled or not */

#if !defined(__STRUCTS_EDD_H)
#define __HAL_EDDPROFINETIRT_CONFIG_ONLY__
#elif !defined(__PN_IRT_NETX__H)
#define __HAL_EDDPROFINETIRT_CONFIG_ONLY__
#endif

#if !defined(__HAL_EDDPROFINETIRT_CONFIG_ONLY__)

/* The enumerators HAL_PND_TX_PORT_E, HAL_PND_TIMESTAMP_BUF_E and HAL_PND_REQ_TRAFFIC_CLASS_E
 * are usen only in CutThrough switch and here don't have any effect, taken only to suppress the compiler errors
 * *************************************************** */
typedef enum HAL_PND_TX_PORT_Etag
{
  HAL_PND_TX_PORT_P0   = 0,
  HAL_PND_TX_PORT_P1   = 1,
  HAL_PND_TX_PORT_BOTH = 2,
  HAL_PND_TX_PORT_AUTO = 3
} HAL_PND_TX_PORT_E;
typedef enum HAL_PND_TIMESTAMP_BUF_Etag
{
  HAL_PND_TIMESTAMP_DIS  = 0,
  HAL_PND_TIMESTAMP_BUF1 = 1,
  HAL_PND_TIMESTAMP_BUF2 = 2,
  HAL_PND_TIMESTAMP_BUF3 = 3
} HAL_PND_TIMESTAMP_BUF_E;
typedef enum HAL_PND_REQ_TRAFFIC_CLASS_Etag
{
  HAL_PND_REQ_TC_PRIO3_0  = 0,
  HAL_PND_REQ_TC_PRIO4    = 1,
  HAL_PND_REQ_TC_PRIO5    = 2,
  HAL_PND_REQ_TC_PRIO6    = 3,
  HAL_PND_REQ_TC_PRIO6_RT = 4,
  HAL_PND_REQ_TC_PRIO7    = 5,
  HAL_PND_REQ_TC_NWC_LO   = 6,
  HAL_PND_REQ_TC_NWC_HI   = 7
} HAL_PND_REQ_TRAFFIC_CLASS_E;
#define SRT_HAL_PND_PORT             0
#define SRT_HAL_PND_TIMESTAMPBUF     4
#define SRT_HAL_PND_REQTRAFFICCLASS  8
/* *************************************************** */

typedef enum
{
  EDDPNIRT_PRIORITY_LOW = 0,
  EDDPNIRT_PRIORITY_HIGH,
  EDDPNIRT_PRIORITY_ORANGE_UNSUPPORTED,
  EDDPNIRT_PRIORITY_RED
} EDDPNIRT_PRIORITY_E;

typedef enum
{
  EDDPNIRT_PORTSTATE_FORWARDING,
  EDDPNIRT_PORTSTATE_BLOCKED,
  EDDPNIRT_PORTSTATE_DISABLED,
} EDDPNIRT_PORTSTATE_E;

typedef enum
{
  PNIRT_IOCTL_GET_PHY_PHASE_OFFSET_REQ = 0xf00, /* @TODO: check this value */
  PNIRT_IOCTL_GET_PHY_PHASE_OFFSET_CNF,
  PNIRT_IOCTL_SET_LINEDELAY_REQ,
  PNIRT_IOCTL_SET_LINEDELAY_CNF,
  PNIRT_IOCTL_SET_SINGLE_MACADDR_FILTER_REQ,   /* filter out single mac addr */
  PNIRT_IOCTL_SET_SINGLE_MACADDR_FILTER_CNF,
  PNIRT_IOCTL_CLR_SINGLE_MACADDR_FILTER_REQ,   /* dont filter this mac addr */
  PNIRT_IOCTL_CLR_SINGLE_MACADDR_FILTER_CNF,
  PNIRT_IOCTL_SYNC_REQ,                        /* sync */
  PNIRT_IOCTL_SYNC_CNF,
  PNIRT_IOCTL_RESYNC_REQ,                      /* resync */
  PNIRT_IOCTL_RESYNC_CNF,
  PNIRT_IOCTL_STOPSYNC_REQ,                    /* stop sync and cacle control*/
  PNIRT_IOCTL_STOPSYNC_CNF,
  PNIRT_IOCTL_SET_PRIO_REQ,                     /* set send priority for a given frame */
  PNIRT_IOCTL_SET_PRIO_CNF,
  PNIRT_IOCTL_GET_PRIO_REQ,                     /* get send/recv priority for a given frame */
  PNIRT_IOCTL_GET_PRIO_CNF,
  PNIRT_IOCTL_SET_PORTMACADDR_REQ,
  PNIRT_IOCTL_SET_PORTMACADDR_CNF,
  PNIRT_IOCTL_CLR_MACADDRTABLE_REQ,
  PNIRT_IOCTL_CLR_MACADDRTABLE_CNF,
  PNIRT_IOCTL_SET_PORTSTATE_REQ,
  PNIRT_IOCTL_SET_PORTSTATE_CNF,
  PNIRT_IOCTL_REGISTER_IRT_REQ,
  PNIRT_IOCTL_REGISTER_IRT_CNF,
  PNIRT_IOCTL_WRITE_RESYNC_REQ,
  PNIRT_IOCTL_WRITE_RESYNC_CNF,
  PNIRT_IOCTL_GET_SWITCH_TYPE_REQ,
  PNIRT_IOCTL_GET_SWITCH_TYPE_CNF
} PNIRT_IOCTL_E;

typedef struct
{
  /* Additional Receive Delay in ns */
  UINT32 aulPhaseOffset[2];

} PNIRT_IOCTL_GET_PHY_PHASE_OFFSET_T;

typedef struct
{
  /* Portnumber to set the LineDelay */
  UINT32      ulPort;
  /* LineDelay of the port */
  UINT32      ulLineDelay1ns;
} PNIRT_IOCTL_SET_LINEDELAY_T;

typedef struct
{
  /* Portnumber to filter the mac addr on */
  UINT32      ulPort;

  /* The Macaddr to filter/not to filter */
  EDD_MAC_ADDR_T tMacAddr;
} PNIRT_IOCTL_SINGLE_MACADDR_FILTER_T;

typedef struct
{
  /** masters time */
  unsigned long long  ullMasterTime10ns;

  /** Time we received the frame */
  unsigned long long  ullSlaveTime10ns;

  /** Deviation of clock since first sync in 10ns, filled in by pnirt hal */
  long long  llTimeDeviation10ns;
} PNIRT_IOCTL_TIME_T;

typedef struct
{
  /** the frame */
  EDD_ETHERNET_FRAME_T * ptFrame;

  /** the desired priority */
  unsigned long          ulPrio;

  /** the desired send offset in 10ns*/
  unsigned long          ulSendOffset10ns;
} PNIRT_IOCTL_PRIO_T;


typedef struct
{
  EDD_MAC_ADDR_T atMacAddr[2];
} PNIRT_IOCTL_PORTMAC_T;

typedef TLR_VOID (*PNIRT_INTERRUPT_CLB_T)(TLR_HANDLE hUserParam, TLR_UINT32 ulIrqMask);

typedef struct PNIRT_IRT_FUNCTIONS_Ttag
{
 PNIRT_RESULT (*pfnPnIrt_FrameCfgList_AddLocalFrm)   (unsigned int uPortNo, unsigned long ulFCListIdx, void* hFrame, unsigned int uLength, unsigned long ulSendTime, int fSync);
 PNIRT_RESULT (*pfnPnIrt_FrameCfgList_AddFrwdFrm)    (unsigned int uPortNo, unsigned long ulFCListIdx, unsigned int ulLength, unsigned long ulSendOffset10ns, unsigned int fSync);
 PNIRT_RESULT (*pfnPnIrt_FrameCfgList_AddIntervalCfg)(unsigned int uPortNo, unsigned long ulFCListIdx, unsigned long ulRedEndOffset10ns, unsigned long ulYellowStartOffset10ns);
 PNIRT_RESULT (*pfnPnIrt_CycleCfgList_AddEntry)      (unsigned int uPortNo, unsigned long ulCCListNumber, unsigned long ulCCListIdx, unsigned long ulFCListIdx);
 PNIRT_RESULT (*pfnPnIrt_AddRxPhaseListEntry)        (unsigned int uPortNo, unsigned long ulRxListIdx, unsigned long ulFSOffsetRxResBegin, unsigned long ulFSOffsetRxResEnd);

 PNIRT_RESULT (*pfnPnIrt_GetFreeCycleCfgList)        (unsigned int uPortNo, unsigned long* pulCCListNumber);
 PNIRT_RESULT (*pfnPnIrt_SetNextCycleCfgList)        (unsigned int uPortNo, unsigned long ulCCListNumber);

 PNIRT_RESULT (*pfnPnIrt_GetTimeDiff)                (long long* llTimeDiff);

 PNIRT_RESULT (*pfnPnIrt_SetCommIrqMask)             (unsigned int uPortNo, unsigned long ulIrqMask);
 PNIRT_RESULT (*pfnPnIrt_GetCommIrqMask)             (unsigned int uPortNo, unsigned long *pulIrqMask);
 PNIRT_RESULT (*pfnPnIrt_GetCommIrq)                 (unsigned int uPortNo, unsigned long *pulIrq, int fPriority);
 PNIRT_RESULT (*pfnPnIrt_ConfirmCommIrq)             (unsigned int uPortNo, unsigned long ulConfirmIrqMask, int fPriority);

 PNIRT_RESULT (*pfnPnIrt_SetSyncIrqMask)             (unsigned long ulIrqMask);

 PNIRT_RESULT (*pfnPnIrt_EstablishCycleControl)      (PNIRT_CYCLE_CFG_T* ptCycleCfg);
 PNIRT_RESULT (*pfnPnIrt_DisableCycleControl)        ();

 PNIRT_RESULT (*pfnPnIrt_EnableTrigger)              (unsigned long ulTriggerId, PNIRT_TRIGGER_PARAMETER_T* ptTrigParam);
 PNIRT_RESULT (*pfnPnIrt_DisableTrigger)             (unsigned long ulTriggerId);
 PNIRT_RESULT (*pfnPnIrt_SetRedGuard)                (unsigned long ulRedGuardBegin, unsigned long ulRedGuardEnd);

} PNIRT_IRT_FUNCTIONS_T;

typedef struct {
  PNIRT_INTERRUPT_CLB_T pfnInterrupt;

  TLR_HANDLE            hUserParam;

  PNIRT_IRT_FUNCTIONS_T *ptCallbacks;
} PNIRT_IOCTL_REGISTER_IRT_T;

typedef struct
{
  /* portnumber */
  TLR_UINT              uiPortNum;

  /* desired state */
  EDDPNIRT_PORTSTATE_E  eState;
} PNIRT_IOCTL_PORSTATE_T;
/** @} */
#endif


/**
 * @defgroup Parameters to be used for configuration of the pn-irt edd
 * hal and the xc driver.
 *
 * @{
 */

/**
 * Special parameters to use for configuration
 * of edd irt hal
 */

typedef enum {
  RX_PNIRT_EDD_PARAM_TASK_PRIO = 0xe000,
  RX_PNIRT_EDD_PARAM_TASK_TOK,
  RX_PNIRT_EDD_PARAM_TASK_NAME
} RX_PNIRT_EDD_PARAM_E;

/**
 * EddHal function pointers of PnIrt EDD HAL to use
 * with edd driver.
 */

extern HAL_EDD_OPERATIONS_T trEddHalPnIRT;

/**
 * pointers to xpec microcodes to use for profinet irt
 */

#if !defined(__NETX50) && !defined(__NETX100) && !defined(__NETX500)
#error "Unsupport platform. Please define either __NETX50, __NETX100 or __NETX500"
#endif

/**
 * XPEC 0 & 1 for all platforms
 */
extern const unsigned long XcCode_rpu_pn_irt0[];
extern const unsigned long XcCode_rpu_pn_irt1[];

extern const unsigned long XcCode_tpu_pn_irt0[];
extern const unsigned long XcCode_tpu_pn_irt1[];

extern const unsigned long XcCode_xpec_pn_irt0[];
extern const unsigned long XcCode_xpec_pn_irt1[];

#if defined (__NETX100) || defined (__NETX500)

/**
 * XPEC 3 is doing the sync on netx100/500
 */
extern const unsigned long XcCode_rpu_pn_irt_sync3[];

extern const unsigned long XcCode_tpu_pn_irt_sync3[];

extern const unsigned long XcCode_xpec_pn_irt_sync3[];

#endif

/** @} */

#endif /* HAL_EDDPROFINETIRT_H_ */
